//
//  Octorok.m
//  The Obfuscated Path
//
//  Created by ss2cire on 1/4/09.
//  Copyright 2009 GryphonClaw Software. All rights reserved.
//

#import "Octoroc.h"

NSString *textureFormat = @"Octoroc%@_%@";
NSString *OPCreateItemNotification = @"OPCreateItem";

@implementation Octoroc

- (void)setEnemyData:(NSDictionary *)data
{
	textures = [[data objectForKey:@"Textures"] retain];
	variation = [[data objectForKey:@"Variation"] intValue];

	variationColor = (variation ? @"Blue" : @"Red");
	NSString *textureName = [NSString stringWithFormat:textureFormat, variationColor, @"Up2"];

	textureID = [[textures objectForKey:textureName] unsignedIntValue];
	moveSpeed = ((variation == 0) ? 90 : 120) * UPDATE_INTERVAL;
	maxHealth = ((variation == 0) ? 1  : 2); //if the octoroc is blue, give it 2 hit points, otherwise give it 1
	currentHealth = maxHealth;
	switch(random() % 4) {
		case OPUp:
			[self setMovingUp:YES];
			break;
		case OPDown:
			[self setMovingDown:YES];
			break;
		case OPLeft:
			[self setMovingLeft:YES];
			break;
		case OPRight:
			[self setMovingRight:YES];
			break;
	}
}

-(void)setNewDirectionExcluding:(OPDirection)theDirection
{
	OPDirection newDirection;
	do {
		[self stop];
		newDirection = (random() % 4);
		switch(newDirection) {
			case OPUp:
				[self setMovingUp:YES];
				break;
			case OPDown:
				[self setMovingDown:YES];
				break;
			case OPLeft:
				[self setMovingLeft:YES];
				break;
			case OPRight:
				[self setMovingRight:YES];
				break;
		}
	}while(theDirection == newDirection);
	currentDirection = newDirection;
}

- (void)draw
{
	if(hit) {
		glColor3b(0.5, 0.5, 0.5);
	}
	[super draw];
	if(!hit) {
		glColor3d(1.0, 1.0, 1.0);
	}
}

- (void)update
{
	if([self location].x < 16 || [self location].y < 16 || [self location].x > 480 || [self location].y > 310) {
		[self setNewDirectionExcluding:currentDirection];
	}
	numberOfUpdates++;
	#define MIN_ANIMATION_UPDATES_OCTOROC 8
		if(numberOfUpdates >= MIN_ANIMATION_UPDATES_OCTOROC) {
			numberOfUpdates = 0;
			
			if([self isMovingUp]) {
				if(textureID == [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Up1"]]) {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Up2"]];
				} else {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Up1"]];
				}
			} else if([self isMovingDown]) {
				if(textureID == [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Down1"]]) {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Down2"]];
				} else {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Down1"]];
				}
			} else if([self isMovingLeft]) {
				if(textureID == [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Left1"]]) {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Left2"]];
				} else {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Left1"]];
				}
			} else if([self isMovingRight]) {
				if(textureID == [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Right1"]]) {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Right2"]];
				} else {
					textureID = [self textureWithName:[NSString stringWithFormat:textureFormat, variationColor, @"Right1"]];
				}
			}
		}
		[super update];
}

- (void)kill
{
	NSMutableDictionary *itemInfo = [[NSMutableDictionary alloc] init];
	
	//int theItemType = rand() % 2;
	
	//switch (theItemType) {
	//	case 0:
			[itemInfo setObject:@"heart" forKey:@"ItemType"];
			[itemInfo setObject:@"item_heart" forKey:@"Texture_Name"];
	//		break;
	//	default:
	//		break;
	//}
	
	[itemInfo setObject:NSStringFromPoint(location) forKey:@"Location"];
	[[NSNotificationCenter defaultCenter] postNotificationName:@"OPCreateItem" object:itemInfo];
}

- (BOOL)hurt
{
	return [super hurt];
}
@end
